<Query Kind="Statements">
  <Namespace>System.Runtime.Serialization</Namespace>
  <Namespace>System.Text.Json</Namespace>
  <Namespace>System.Text.Json.Serialization</Namespace>
</Query>

var options = new JsonWriterOptions { Indented = true };

using (var stream = File.Create ("MyFile.json"))
using (var writer = new Utf8JsonWriter (stream, options))
{
	writer.WriteStartObject();
	// Nazwa i wartość własności określone w jednym wywołaniu
	writer.WriteString ("FirstName", "Dylan");
	writer.WriteString ("LastName", "Lockwood");
	// Nazwa i wartość własności określone w osobnych wywołaniach
	writer.WritePropertyName ("Age");
	writer.WriteNumberValue (46);
	writer.WriteCommentValue ("To jest (niestandardowy) komentarz.");
	writer.WriteEndObject();
}

File.ReadAllText("MyFile.json").Dump();